<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="banner">
        <div class="container">
            <div class="row">
                <div class="col-xl-8">
                    <form action="<?php echo e(route('exchange.amount')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="banner-content">
                            <h1><?php echo e($basic->section1_heading); ?></h1>
                            <p><?php echo e($basic->section1_para); ?></p>

                            <?php echo $__env->make('errors.error', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                            <div class="exchange-button">
                                <input type="text" name="from_amount" class="from_amount" placeholder="0.00"
                                       autocomplete="off"
                                       onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                                <select name="from_currency_id" id="from_currency_id">
                                    <?php $__currentLoopData = $currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>"
                                                data-id="<?php echo e($data->id); ?>"
                                                data-name="<?php echo e($data->name); ?>"
                                                data-symbol="<?php echo e($data->symbol); ?>"
                                                data-price="<?php echo e($data->price); ?>"
                                                data-available="<?php echo e($data->available_balance); ?>"
                                                data-exchange="<?php echo e($data->exchange); ?>"
                                                data-sell="<?php echo e($data->sell); ?>"
                                                data-buy="<?php echo e($data->buy); ?>"
                                                data-paymentId="<?php echo e($data->payment_id); ?>"
                                        ><?php echo e($data->symbol); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="icon">
                                    <i class="fas fa-angle-down"></i>
                                </div>
                            </div>
                            <div class="exchange-button">
                                <input type="text" name="receive_amount" class="receive_amount" readonly
                                       placeholder="0.00" autocomplete="off"
                                       onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                                <select name="receive_currency_id" id="receive_currency_id">
                                    <?php $__currentLoopData = $currency2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>"
                                                data-id="<?php echo e($data->id); ?>"
                                                data-name="<?php echo e($data->name); ?>"
                                                data-symbol="<?php echo e($data->symbol); ?>"
                                                data-price="<?php echo e($data->price); ?>"
                                                data-available="<?php echo e($data->available_balance); ?>"
                                                data-exchange="<?php echo e($data->exchange); ?>"
                                                data-sell="<?php echo e($data->sell); ?>"
                                                data-buy="<?php echo e($data->buy); ?>"
                                                data-paymentId="<?php echo e($data->payment_id); ?>"><?php echo e($data->symbol); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="icon">
                                    <i class="fas fa-angle-down"></i>
                                </div>
                            </div>
                        </div>

                        <div class="exchange-now">
                            <button type="submit" class="exchange-now-button">Exchange Now</button>

                        </div>

                    </form>

                </div>
            </div>
        </div>

    </div>


    <div class="service-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <div class="area-title">
                        <h2><?php echo e($basic->service_heading); ?></h2>
                        <p><?php echo e($basic->service_para); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-4 col-sm-12 col-md-6">
                        <div class="single-service">
                            <div class="part-icon">
                                <?php echo $data->icon; ?>

                            </div>
                            <div class="part-text">
                                <h3><?php echo e($data->title); ?></h3>
                                <p><?php echo e(str_limit($data->details,90)); ?></p>
                                <a href="<?php echo e(route('serve',[$data->id, str_slug($data->title)])); ?>">Read more</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>



    <div class="payout-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <div class="area-title">
                        <h2 class="plus-margin"><?php echo e($basic->payout_title); ?></h2>
                        <p><?php echo e($basic->payout_details); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-xl-12">

                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Exchange <br> <br/></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Sell  <br><br/></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Buy  <br><br/></a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="chart">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col">Date</th>
                                        <th scope="col">Currency</th>
                                        <th scope="col">Exchanger Name	</th>
                                        <th scope="col"> Amount</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $exchange; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><i class="fas fa-calendar-alt"></i> <?php echo e(date('d F Y', strtotime($data->created_at))); ?></th>
                                        <td> <?php echo e($data->toCurrency->name); ?></td>
                                        <td><?php echo e($data->user->fname); ?> <?php echo e($data->user->lname); ?></td>
                                        <td><i class="icofont-money"></i> <?php echo e($data->receive_amount); ?> <span><?php echo e($data->toCurrency->symbol); ?></span></td>

                                    </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="chart">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col">Date</th>
                                        <th scope="col">Currency</th>
                                        <th scope="col">Seller Name	</th>
                                        <th scope="col"> Amount</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $sellMoney; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><i class="fas fa-calendar-alt"></i> <?php echo e(date('d F Y', strtotime($data->created_at))); ?></th>
                                        <td><?php echo e($data->currency->name); ?></td>
                                        <td><?php echo e($data->user->fname); ?> <?php echo e($data->user->lname); ?></td>
                                        <td><i class="icofont-money"></i> <?php echo e($data->enter_amount); ?> <span><?php echo e($data->currency->symbol); ?></span></td>
                                    </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                            <div class="chart">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col">Date</th>
                                        <th scope="col">Currency</th>
                                        <th scope="col">Buyer Name	</th>
                                        <th scope="col"> Amount</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $buyMoney; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><i class="fas fa-calendar-alt"></i> <?php echo e(date('d F Y', strtotime($data->created_at))); ?></th>
                                        <td><?php echo e($data->currency->name); ?></td>
                                        <td><?php echo e($data->user->fname); ?> <?php echo e($data->user->lname); ?></td>
                                        <td><i class="icofont-money"></i> <?php echo e($data->get_amount); ?> <span><?php echo e($data->currency->symbol); ?></span></td>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




    <div class="signup-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <div class="area-title">
                        <h2>Subscribe For More Updates</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row justify-content-around d-flex">
                <div class="col-md-8">
                    <div class="form">
                        <form class="signup-form" action="<?php echo e(route('subscribe')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="mail-area">
                                <p class="text-center">Please Subscribe & Get Updates</p>
                                <input type="email" name="email" placeholder="Enter your email here..." required>
                                <i class="icofont-email"></i>
                            </div>
                            <button type="submit" class="submit-button">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="client-comments">

        <div class="container">
            <div class="row justify-content-xl-between justify-content-sm-center">
                <div class="col-lg-12">
                    <div class="all-comments">
                        <?php $__currentLoopData = $testimonial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="single-comment">
                            <div class="part-img">
                                <img src="<?php echo e(asset('assets/images/testimonial/'.$data->image)); ?>" alt="..." class="rounded-circle">
                            </div>
                            <div class="part-text">
                                <h3><?php echo e($data->name); ?></h3>
                                <h4><?php echo e($data->designation); ?></h4>
                                <p><?php echo $data->details; ?></p>
                            </div>
                        </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>



            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

    <script>
        $(document).ready(function () {
            var from_amount = $(".from_amount").val();
            var receive_amount = $(".receive_amount").val();

            $(".from_amount, #from_currency_id, .receive_amount, #receive_currency_id ").on('keyup change', function () {

                var enterAmount = $(".from_amount").val();
                var fromAmountPrice = $("#from_currency_id option:selected").data('price');
                var fromAmountExchangeCharge = $("#from_currency_id option:selected").data('exchange');

                var receiveAmountPrice = $("#receive_currency_id option:selected").data('price');
                var receiveAmountExchangeCharge = $("#receive_currency_id option:selected").data('exchange');


                var getAmountTotal = parseFloat((receiveAmountPrice/ fromAmountPrice)*enterAmount);
                var chargeFromTotalAmoFromEnter = parseFloat((getAmountTotal*receiveAmountExchangeCharge)/100);
                var getAmountInput = parseFloat((getAmountTotal - chargeFromTotalAmoFromEnter));
                $(".receive_amount").val(getAmountInput.toFixed(8));
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>